using System;
using System.IO;
using System.Xml;
using System.Text;
using System.Data;
using System.Resources;

namespace gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages
{
	#region Header

	//<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	//<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	//<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	//<Developers>
	//	<Developer>Brian    lin</Developer>
	//</Developers>
	//<SiteName>Hines OIFO</SiteName>
	//<CreationDate>10/19/2004</CreationDate>
	//<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	//<summary>Base class for all HL7 protocol messages.</summary>

	#endregion

	/// <summary>
	/// 
	/// </summary>
	public abstract class HL7ProtocolMessage
	{
		private const string START_OF_TEXT_CHARACTER = "\x0B";
		private const string FILE_SEPARATOR_CHARACTER = "\x1C";
		private const string END_OF_TEXT_CHARACTER = "\x0D";

		/// <summary>
		/// Full HL7 message text.
		/// </summary>
		protected string _message;

		/// <summary>
		/// Message Control ID of the current message.
		/// </summary>
		protected string _messageControlID;

		/// <summary>
		/// HL7 message type. For example 'OMG'.
		/// </summary>
		protected string _messageType;

		/// <summary>
		/// Empty static constructor added to get rid of "beforefieldinit" attribute generated by compiler.
		/// </summary>
		static HL7ProtocolMessage() {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="message"></param>
		protected HL7ProtocolMessage( string message )
		{
			if( message == null )
				throw( new ArgumentNullException( "message" ) );

			_message = message;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public abstract string GetMessage();

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public abstract string GetMessageControlID();

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public abstract string GetMessageType();

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public abstract bool IsResponseRequired();

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		protected abstract void WriteHL7MessageBody( StreamWriter writer );

		/// <summary>
		/// Serializes message and packs it to byte array.
		/// </summary>
		/// <returns>HL7 message packed to byte array.</returns>
		public byte[] ToByteArray()
		{
			return ToByteArray( Formatting.None );
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="format"></param>
		/// <returns></returns>
		private byte[] ToByteArray( Formatting format )
		{
			var stream = new MemoryStream();
			var writer = new StreamWriter( stream, Encoding.ASCII );
			
            writer.Write(START_OF_TEXT_CHARACTER);
			WriteHL7MessageBody( writer );
			writer.Write(FILE_SEPARATOR_CHARACTER);
			writer.Write(END_OF_TEXT_CHARACTER);

			writer.Flush();

			writer.Close();

			return stream.ToArray();
		}

        //TODO: dkozlov, rename it to ToByteArray. All control bytes are applied in communication layer now.
        //TODO: Do it after making sure that HL7 dispatcher uses communication layer to send messages.
        /// <summary>
		/// </summary>
		/// <returns></returns>
		public byte[] ToByteArrayWithoutControlCharacters()
		{
			var stream = new MemoryStream();
			var writer = new StreamWriter( stream, Encoding.ASCII );
			WriteHL7MessageBody( writer );
			writer.Flush();
			writer.Close();
			return stream.ToArray();
		}
	}
}
